/*  Command script executed prior to launch official script  */
/*  Used to synchronize builtins environment                 */

//! @li 2007/05/11 B. DAVID EVO #3293 : POI upgrade

/*** TYPES ***/

typedef int  STATUS;
typedef int  BOOL;
typedef void *MODULE_ID;


/*** CONSTANTS ***/

#define TRUE     (1)
#define FALSE    (0)
#define OK       (0)
#define ERROR    (-1)
#define NULL     (void*) 0

#define O_RDONLY (0)
#define O_RDWR   (2)

#define LOAD_NO_SYMBOLS         2
#define LOAD_LOCAL_SYMBOLS      4
#define LOAD_GLOBAL_SYMBOLS     8
#define LOAD_ALL_SYMBOLS       12

#define BUILTINS_FILE_NORMAL  "UPG/builtins.out"
#define OFFICIAL_UPG_SCRIPT   "/UPG/POI_UPGRADE_SUB.CMD"

#define MAX_PATH_LENGTH 200


/*** EXTERN FUNCTION DEFINITIONS ***/

int EiC_ExeFile(int argc, char **argv);

MODULE_ID LoadAndExecuteFile( char*   p_root,
                           char*   p_file_name,
                           int           p_ld_symb,
                           int           p_invalid,
                           unsigned int  p_delay);

int logMsg (char *str,int p1,int p2,int p3,int p4,int p5,int p6);

STATUS strcpy (char* target, char* source);
STATUS strcat (char* target, char* source);
int strcmp (char* str1, char* str2);

STATUS ShowCDProblem(void);
STATUS ClearScreen(void);

STATUS UPGCDEject(void);

STATUS taskDelay (int ticks);


/*** MAIN ***/

int main ( int argc, char **argv )
{
  STATUS l_script_status = OK;
  char * l_pTab[3];
  char l_pScriptFile[MAX_PATH_LENGTH];
  char l_pSourceDrive[MAX_PATH_LENGTH];
  char l_pUpgType[MAX_PATH_LENGTH];

  char l_pString[MAX_PATH_LENGTH];
  int l_iFd = 0;
  char l_pSourcePath[MAX_PATH_LENGTH];
  MODULE_ID l_pModuleId = NULL;
  l_pTab[0] = l_pString;

  l_pTab[0] = l_pScriptFile;
  l_pTab[1] = l_pSourceDrive;
  l_pTab[2] = l_pUpgType;

  // Builtins loading
  if ( NULL ==
       LoadAndExecuteFile ( argv[1],
                            BUILTINS_FILE_NORMAL,
                            LOAD_GLOBAL_SYMBOLS,
                            ERROR,
                            0 ) )
  {
    logMsg ( "LoadAndExecuteFile error on %s BUILTINS_FILE_NORMAL\n",
             (char*)argv[1], 0,0,0,0,0 );
    ShowCDProblem();
    UPGCDEject();
    taskDelay(2000);
    ClearScreen();
    l_script_status = ERROR;
  }

  // Launch script
  if ( OK == l_script_status )
  {
    strcpy ( l_pScriptFile, argv[1] );
    strcat ( l_pScriptFile, OFFICIAL_UPG_SCRIPT );
    strcpy ( l_pSourceDrive, argv[1] );
    strcpy ( l_pUpgType, argv[2] );

    if ( ERROR == EiC_ExeFile(3, l_pTab) )
    {
      logMsg ( "EiC_ExeFile error on %s\n",
               (char*)l_pScriptFile, 0,0,0,0,0 );
      ShowCDProblem();
      UPGCDEject();
      taskDelay(2000);
      ClearScreen();
      l_script_status = ERROR;
    }
  }

  return l_script_status;
}

